<?php $__env->startSection('title', 'My Exams'); ?>

<?php $__env->startSection('content'); ?>
<h1>My Exams</h1>
<table class="table">
    <thead>
        <tr>
            <th>Exam</th>
            <th>Attempts</th>
            <th>Max Attempts</th>
            <th>Status</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $studentExams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $studentExam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($studentExam->exam->name); ?></td>
            <td><?php echo e($studentExam->attempts); ?></td>
            <td><?php echo e($studentExam->exam->max_attempts); ?></td>
            <td>
                <?php if($studentExam->results()->where('passed', true)->exists()): ?>
                    Passed
                <?php elseif($studentExam->attempts >= $studentExam->exam->max_attempts): ?>
                    Max Attempts Reached
                <?php else: ?>
                    Not Passed
                <?php endif; ?>
            </td>
            <td>
                <?php if($studentExam->results()->where('passed', true)->exists()): ?>
                    <a href="<?php echo e(route('student.exam.result', $studentExam->exam->id)); ?>" class="btn btn-sm btn-info">View Result</a>
                <?php elseif($studentExam->attempts >= $studentExam->exam->max_attempts): ?>
                    <a href="<?php echo e(route('exam.purchase', $studentExam->exam->id)); ?>" class="btn btn-sm btn-primary">Repurchase</a>
                <?php else: ?>
                    <a href="<?php echo e(route('student.exam.attempt', $studentExam->exam->id)); ?>" class="btn btn-sm btn-primary">Attempt</a>
                <?php endif; ?>
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Kloudoz_project\WSglobe\online-exam-portal\resources\views/student/exams.blade.php ENDPATH**/ ?>