<?php $__env->startSection('title', 'Attempt Exam'); ?>

<?php $__env->startSection('content'); ?>
<style>
    #timer {
        position: fixed;
        top: 20px;
        right: 20px;
        background-color: #ff4d4f;
        color: white;
        font-size: 1.5rem;
        font-weight: bold;
        padding: 10px 20px;
        border-radius: 10px;
        z-index: 9999;
        box-shadow: 0 0 10px rgba(0,0,0,0.2);
        font-family: 'Courier New', Courier, monospace;
    }
</style>

<div id="timer"></div>

<h1><?php echo e($exam->name); ?></h1>
<form id="exam-form" method="POST" action="<?php echo e(route('student.exam.submit', $exam->id)); ?>">
    <?php echo csrf_field(); ?>
    <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="mb-4">
        <p><strong>Question <?php echo e($index + 1); ?>:</strong> <?php echo e($question->question); ?></p>
        <?php $__currentLoopData = $question->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $optionIndex => $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="form-check">
            <input class="form-check-input" type="radio" name="answers[<?php echo e($question->id); ?>]" value="<?php echo e($optionIndex); ?>" required>
            <label class="form-check-label"><?php echo e($option); ?></label>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <button type="submit" class="btn btn-primary">Submit Exam</button>
</form>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const durationInMinutes = <?php echo json_encode($exam->duration_minutes, 15, 512) ?>;
        let timeLeft = durationInMinutes * 60;

        const timerDisplay = document.getElementById('timer');
        const examForm = document.getElementById('exam-form');

        function updateTimer() {
            const minutes = Math.floor(timeLeft / 60);
            const seconds = timeLeft % 60;
            timerDisplay.textContent = `${String(minutes).padStart(2, '0')}:${String(seconds).padStart(2, '0')}`;
            timeLeft--;

            if (timeLeft < 0) {
                clearInterval(timerInterval);
                alert("Time is up! Submitting your exam...");
                examForm.submit();
            }
        }

        updateTimer();
        const timerInterval = setInterval(updateTimer, 1000);
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Kloudoz_project\WSglobe\online-exam-portal\resources\views/student/exam-attempt.blade.php ENDPATH**/ ?>