<?php $__env->startSection('title', 'Sub Topics'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">
        <h2>Sub Topics of: <?php echo e($topic->topic_name); ?></h2>

        <a href="<?php echo e(route('admin.subtopics.create', $topic->id)); ?>" class="btn btn-success mb-3">
            Add Sub Topic
        </a>

        <?php if(session('success')): ?>
            <div class="alert alert-success"><?php echo e(session('success')); ?></div>
        <?php endif; ?>

        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>SI.No</th>
                    <th>Name</th>
                    <th>Description</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $subtopics; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $subTopic): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($index + 1); ?></td>
                        <td><?php echo e($subTopic->name); ?></td>
                        <td><?php echo e($subTopic->description); ?></td>
                        <td>
                            <a href="<?php echo e(route('admin.sub-topics.edit', $subTopic->id)); ?>" class="btn btn-sm btn-warning">
                                Edit
                            </a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="4">No sub-topics found for this topic.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Kloudoz_project\WSglobe\online-exam-portal\resources\views/admin/subtopics-index.blade.php ENDPATH**/ ?>