<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2>All Coupons</h2>
        <a href="<?php echo e(route('admin.coupons.create')); ?>" class="btn btn-success">Create New Coupon</a>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <?php if($coupons->count()): ?>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Code</th>
                    <th>Type</th>
                    <th>Value</th>
                    <th>Usage Limit</th>
                    <th>Used</th>
                    <th>Remarks</th>
                    <th>Created At</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $coupons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coupon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><strong><?php echo e($coupon->code); ?></strong></td>
                        <td><?php echo e(ucfirst($coupon->type)); ?></td>
                        <td>
                            <?php echo e($coupon->type === 'percent' ? $coupon->value . '%' : '₹' . $coupon->value); ?>

                        </td>
                        <td><?php echo e($coupon->usage_limit); ?></td>
                        <td><?php echo e($coupon->used_count); ?></td>
                        <td><?php echo e($coupon->remarks ?? '-'); ?></td>
                        <td><?php echo e($coupon->created_at->format('d M Y')); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    <?php else: ?>
        <p>No coupons found.</p>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Kloudoz_project\WSglobe\online-exam-portal\resources\views/admin/coupons-index.blade.php ENDPATH**/ ?>