<?php $__env->startSection('title', 'Exams'); ?>

<?php $__env->startSection('content'); ?>
<h1>Exams</h1>
<a href="<?php echo e(route('admin.exams.create')); ?>" class="btn btn-primary mb-3">Create Exam</a>
<table class="table">
    <thead>
        <tr>
            <th>Name</th>
            <th>Amount</th>
            <th>Topic</th>
            <th>category</th>
            <th>Max Attempts</th>
            <th>Total Mark</th>
            <th>Pass Mark</th>
            <th>Status</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $exams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($exam->name); ?></td>
            <td>$<?php echo e($exam->amount); ?></td>
            <td>
                <?php echo e($topics->firstWhere('id', $exam->topic_id)?->topic_name ?? 'N/A'); ?>

            </td>
            <td>
                <?php echo e($testCategories->firstWhere('id', $exam->test_category_id)?->testcategory_name ?? 'N/A'); ?>

            </td>

            <td><?php echo e($exam->max_attempts); ?></td>
            <td><?php echo e($exam->total_mark); ?></td>
            <td><?php echo e($exam->pass_mark); ?></td>
            <td><?php echo e($exam->is_active ? 'Active' : 'Inactive'); ?></td>
            <td>
                <a href="<?php echo e(route('admin.exams.edit', $exam->id)); ?>" class="btn btn-sm btn-warning">Edit</a>
                <a href="<?php echo e(route('admin.questions', $exam->id)); ?>" class="btn btn-sm btn-info">Questions</a>
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Kloudoz_project\WSglobe\online-exam-portal\resources\views/admin/exams.blade.php ENDPATH**/ ?>