<?php $__env->startSection('title', 'Exams'); ?>

<?php $__env->startSection('content'); ?>
<h1>Available Test</h1>
<div class="row">
    <?php $__currentLoopData = $exams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="col-md-4 mb-4">
        <div class="card">
            <img src="<?php echo e($exam->image ? asset('storage/' . $exam->image) : 'https://via.placeholder.com/150'); ?>" class="card-img-top" alt="<?php echo e($exam->name); ?>">
            <div class="card-body">
                <h5 class="card-title"><?php echo e($exam->name); ?></h5>
                <h5 class="card-title"><?php echo e($topics->firstWhere('id', $exam->topic_id)?->topic_name ?? 'N/A'); ?></h5>
                <h5 class="card-title"><?php echo e($testCategories->firstWhere('id', $exam->test_category_id)?->testcategory_name ?? 'N/A'); ?></h5>
                

                <a href="<?php echo e(route('exam.purchase', $exam->id)); ?>" class="btn btn-primary">Buy Now</a>

                <p class="card-text"> price details:</p>



                <?php
    $currency = session('currency', 'USD');
    $testCat = $exam->testCategory;

    $price = match ($currency) {
        'AED' => $testCat->gcc_std ?? 0,
        'INR' => $testCat->ind_std ?? 0,
        default => $testCat->us_std ?? 0,
    };
?>

<p class="card-text">Price: <?php echo e(number_format($price, 2)); ?> <?php echo e($currency); ?></p>



            </div>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Kloudoz_project\WSglobe\online-exam-portal\resources\views/exams.blade.php ENDPATH**/ ?>