<?php $__env->startSection('title', 'Edit topic'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0">Edit topic</h4>
        </div>
        
        <div class="card-body">
            <form method="POST" action="<?php echo e(route('admin.topics.update', $topic->id)); ?>" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>

                <div class="row">
                    <div class="mb-3 col-md-6">
                        <label for="topic_name" class="form-label">Topic Name</label>
                        <input type="text" class="form-control" id="topic_name" name="topic_name" value="<?php echo e($topic->topic_name); ?>" required>
                    </div>

                    <div class="mb-3 col-md-6">
                        <label for="topic_Percentage" class="form-label">Percentage</label>
                        <input type="number" class="form-control" id="topic_Percentage" name="topic_Percentage" value="<?php echo e($topic->topic_Percentage); ?>" required>
                    </div>

                    <div class="mb-3 col-md-6">
                        <label for="topic_image" class="form-label">topic Image</label>
                        <input type="file" class="form-control" id="topic_image" name="topic_image">
                        <?php if($topic->topic_image): ?>
                            <div class="mt-2">
                                <img src="<?php echo e(asset('storage/' . $topic->topic_image)); ?>" alt="<?php echo e($topic->name); ?>" width="120" class="img-thumbnail">
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="d-grid mt-3">
                    <button type="submit" class="btn btn-success">Update topic</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Kloudoz_project\WSglobe\online-exam-portal\resources\views/admin/topic-edit.blade.php ENDPATH**/ ?>