<?php $__env->startSection('title', 'Edit Question'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mt-5">
    <h2 class="mb-4">Edit Question for <strong><?php echo e($exam->name); ?></strong></h2>

    <form method="POST" action="<?php echo e(route('admin.questions.update', $question->id)); ?>">
        <?php echo csrf_field(); ?>

        <div class="mb-4">
            <label for="question" class="form-label">Question <span class="text-danger">*</span></label>
            <textarea class="form-control" id="question" name="question" rows="3" required><?php echo e(old('question', $question->question)); ?></textarea>
        </div>

        <h5 class="mb-3">Options</h5>
        <div class="row">
            <?php $__currentLoopData = $question->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-6 mb-3">
                <label for="option_<?php echo e($index); ?>" class="form-label">Option <?php echo e($index + 1); ?></label>
                <input type="text" class="form-control" id="option_<?php echo e($index); ?>" name="options[]" value="<?php echo e(old('options.' . $index, $option)); ?>" required>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <div class="mb-4">
            <label for="correct_option" class="form-label">Correct Option <span class="text-danger">*</span></label>
            <select class="form-select w-50" id="correct_option" name="correct_option" required>
                <option value="">-- Select the correct option --</option>
                <?php for($i = 0; $i < 4; $i++): ?>
                    <option value="<?php echo e($i); ?>" <?php echo e(old('correct_option', $question->correct_option) == $i ? 'selected' : ''); ?>>
                        Option <?php echo e($i + 1); ?>

                    </option>
                <?php endfor; ?>
            </select>
        </div>

        <button type="submit" class="btn btn-primary">💾 Update Question</button>
        <a href="<?php echo e(route('admin.questions', $exam->id)); ?>" class="btn btn-secondary ms-2">Cancel</a>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Kloudoz_project\WSglobe\online-exam-portal\resources\views/admin/question-edit.blade.php ENDPATH**/ ?>