<?php $__env->startSection('title', 'Questions'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mt-5">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Questions for <strong><?php echo e($exam->name); ?></strong></h2>
        <a href="<?php echo e(route('admin.questions.create', $exam->id)); ?>" class="btn btn-success">➕ Add Question</a>
    </div>

    <?php if($questions->isEmpty()): ?>
        <div class="alert alert-info">No questions have been added yet.</div>
    <?php else: ?>
        <table class="table table-bordered table-striped">
            <thead class="table-dark">
                <tr>
                    <th style="width: 2%;">Si.no</th>
                    <th style="width: 30%;">Question</th>
                    <th style="width: 30%;">Options</th>
                    <th style="width: 15%;">Correct Answer</th>
                    <th style="width: 15%;">is_hard</th>
                    <th style="width: 10%;">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($loop->iteration); ?></td>
                    <td><?php echo e($question->question); ?></td>
                    <td>
                        <ol type="A" class="mb-0">
                            <?php $__currentLoopData = $question->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li <?php if($index == $question->correct_option): ?> class="fw-bold text-success" <?php endif; ?>>
                                    <?php echo e($option); ?>

                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ol>
                    </td>
                    <td class="text-success fw-bold">
                        <?php echo e($question->options[$question->correct_option] ?? 'N/A'); ?>

                    </td>
                    <td><?php echo e($question->is_hard ? 'Yes' : 'No'); ?></td>


                    <td>
                        <a href="<?php echo e(route('admin.questions.edit', $question->id)); ?>" class="btn btn-sm btn-primary">Edit</a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Kloudoz_project\WSglobe\online-exam-portal\resources\views/admin/questions.blade.php ENDPATH**/ ?>