<?php $__env->startSection('title', 'Add Question'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mt-5">
    <h2 class="mb-4">Add Question for <strong><?php echo e($exam->name); ?></strong></h2>

    <form method="POST" action="<?php echo e(route('admin.questions.create', $exam->id)); ?>">
        <?php echo csrf_field(); ?>

        <div class="mb-4">
            <label for="question" class="form-label">Question <span class="text-danger">*</span></label>
            <textarea class="form-control" id="question" name="question" rows="3" placeholder="Enter your question here..." required></textarea>
        </div>

        <h5 class="mb-3">Options</h5>
        <div class="row">
            <?php for($i = 0; $i < 4; $i++): ?>
            <div class="col-md-6 mb-3">
                <label for="option_<?php echo e($i); ?>" class="form-label">Option <?php echo e($i + 1); ?></label>
                <input type="text" class="form-control" id="option_<?php echo e($i); ?>" name="options[]" placeholder="Enter option <?php echo e($i + 1); ?>" required>
            </div>
            <?php endfor; ?>
        </div>

        <div class="mb-4">
            <label for="correct_option" class="form-label">Correct Option <span class="text-danger">*</span></label>
            <select class="form-select w-50" id="correct_option" name="correct_option" required>
                <option value="">-- Select the correct option --</option>
                <option value="0">Option 1</option>
                <option value="1">Option 2</option>
                <option value="2">Option 3</option>
                <option value="3">Option 4</option>
            </select>
        </div>

        <div class="mb-4">
        <div class="form-check form-switch mt-4">
            <input type="checkbox" class="form-check-input" id="is_hard" name="is_hard">
            <label class="form-check-label" for="is_hard">Hard</label>
        </div>
        </div>

        <button type="submit" class="btn btn-success">➕ Add Question</button>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Kloudoz_project\WSglobe\online-exam-portal\resources\views/admin/question-create.blade.php ENDPATH**/ ?>