<?php $__env->startSection('title', 'Create Exam'); ?>



<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <div class="card shadow rounded">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0">Create New Exam</h4>
        </div>
        <div class="card-body">
            <form method="POST" action="<?php echo e(route('admin.exams.create')); ?>" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="name" class="form-label">Exam Name</label>
                        <input type="text" class="form-control" id="name" name="name" placeholder="Enter exam title" required>
                    </div>
                    <div class="col-md-6">
                        <label for="amount" class="form-label">Amount ($)</label>
                        <input type="number" class="form-control" id="amount" name="amount" step="0.01" placeholder="0.00" required>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="topic_id" class="form-label">Select Topic</label>
                            <select class="form-select" id="topic_id" name="topic_id" required>
                                <option value="">-- Select Topic --</option>
                                <?php $__currentLoopData = $topics; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $topic): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($topic->id); ?>"><?php echo e($topic->topic_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="col-md-6">
                            <label for="test_category_id" class="form-label">Select Test Category</label>
                            <select class="form-select" id="test_category_id" name="test_category_id" required>
                                <option value="">-- Select Test Category --</option>
                                <?php $__currentLoopData = $testCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($category->id); ?>"><?php echo e($category->testcategory_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>



                </div>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="image" class="form-label">Upload Image</label>
                        <input type="file" class="form-control" id="image" name="image">
                    </div>
                    <div class="col-md-6">
                        <label for="max_attempts" class="form-label">Max Attempts</label>
                        <input type="number" class="form-control" id="max_attempts" name="max_attempts" min="1" placeholder="e.g. 2" required>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="duration_minutes" class="form-label">Duration (in minutes)</label>
                        <input type="number" class="form-control" id="duration_minutes" name="duration_minutes" min="1" placeholder="e.g. 30" required>
                    </div>
                    <div class="col-md-6">
                        <label for="total_mark" class="form-label">Total Marks</label>
                        <input type="number" class="form-control" id="total_mark" name="total_mark" min="1" required>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="mark_per_question" class="form-label">Mark per Question</label>
                        <input type="number" class="form-control" id="mark_per_question" name="mark_per_question" min="1" required>
                    </div>
                    <div class="col-md-6">
                        <label for="pass_mark" class="form-label">Pass Mark</label>
                        <input type="number" class="form-control" id="pass_mark" name="pass_mark" min="1" required>
                    </div>
                </div>

                <div class="col-md-6">
                    <label for="hard_ques" class="form-label">No Of Hard Questions</label>
                    <input type="number" class="form-control" id="hard_ques" name="hard_ques" min="0" required>
                </div>

                <div class="text-end">
                    <button type="submit" class="btn btn-success">Create Exam</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Kloudoz_project\WSglobe\online-exam-portal\resources\views/admin/exam-create.blade.php ENDPATH**/ ?>