<?php $__env->startSection('title', 'Purchase Exam'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <h1>Purchase Exam: <?php echo e($exam->name); ?></h1>
    <p>Amount: $<?php echo e(number_format($exam->amount, 2)); ?></p>

    
    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('exam.checkout', $exam->id)); ?>" method="POST">
        <?php echo csrf_field(); ?>

        
        <div class="mb-3">
            <label for="coupon_code" class="form-label">Coupon Code (optional)</label>
            <input type="text" name="coupon_code" id="coupon_code"
                   class="form-control" value="<?php echo e(old('coupon_code')); ?>"
                   placeholder="Enter your coupon code">
        </div>

        <button type="submit" class="btn btn-primary">
            Pay $<?php echo e(number_format($exam->amount, 2)); ?> via Stripe
        </button>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Kloudoz_project\WSglobe\online-exam-portal\resources\views/exam/purchase.blade.php ENDPATH**/ ?>