<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ExamController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\StudentController;

Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('/exams', [ExamController::class, 'index'])->name('exams');
Route::get('/topics', [ExamController::class, 'topicindex'])->name('topic');
Route::get('/topic/{id}/exam', [ExamController::class, 'showtopicexam'])->name('topic.test');

Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
Route::post('/login', [AuthController::class, 'login']);
Route::get('/register', [AuthController::class, 'showRegister'])->name('register');
Route::post('/register', [AuthController::class, 'register']);

Route::get('/logout', [AuthController::class, 'logout'])->name('logout');


Route::get('/adminlogin', [AdminController::class, 'showAdminLogin'])->name('admin.login');
Route::post('/adminlogin', [AdminController::class, 'adminLogin']);
Route::middleware(['auth', 'role:admin'])->group(function () {
    Route::get('/admin/dashboard', [AdminController::class, 'dashboard'])->name('admin.dashboard');
    Route::get('/admin/exams', [AdminController::class, 'exams'])->name('admin.exams');
    Route::get('/admin/exams/create', [AdminController::class, 'showCreateExam'])->name('admin.exams.create');
    Route::post('/admin/exams/create', [AdminController::class, 'createExam']);
    Route::get('/admin/exams/{id}/edit', [AdminController::class, 'showEditExam'])->name('admin.exams.edit');
    Route::post('/admin/exams/{id}/update', [AdminController::class, 'updateExam'])->name('admin.exams.update');
    Route::get('/admin/exams/{id}/questions', [AdminController::class, 'questions'])->name('admin.questions');
    Route::get('/admin/exams/{id}/questions/create', [AdminController::class, 'showCreateQuestion'])->name('admin.questions.create');
    Route::post('/admin/exams/{id}/questions/create', [AdminController::class, 'createQuestion']);
    // Question management routes
    Route::get('/admin/questions/{question}/edit', [AdminController::class, 'edit'])->name('admin.questions.edit');
    Route::post('/admin/questions/{question}', [AdminController::class, 'update'])->name('admin.questions.update');
    Route::delete('/admin/questions/{question}', [AdminController::class, 'destroy'])->name('admin.questions.destroy');

    Route::get('/admin/students', [AdminController::class, 'students'])->name('admin.students');
    Route::get('/admin/payments', [AdminController::class, 'payments'])->name('admin.payments');
    Route::get('/admin/settings', [AdminController::class, 'settings'])->name('admin.settings');
    Route::post('/admin/settings', [AdminController::class, 'updateSettings']);

    Route::get('/coupons', [AdminController::class, 'couponindex'])->name('admin.coupons.index');
    Route::get('/coupons/create', [AdminController::class, 'couponcreate'])->name('admin.coupons.create');
    Route::post('/coupons/store', [AdminController::class, 'couponstore'])->name('admin.coupons.store');

    Route::get('/admin/topic', [AdminController::class, 'topic'])->name('admin.topic');
    Route::get('/admin/topic/create', [AdminController::class, 'showCreateTopic'])->name('admin.topics.create');
    Route::post('/admin/topic/create', [AdminController::class, 'CreateTopic']);
    Route::get('/admin/topic/{id}/edit', [AdminController::class, 'showEditTopic'])->name('admin.topics.edit');
    Route::post('/admin/topic/{id}/update', [AdminController::class, 'updateTopic'])->name('admin.topics.update');

    Route::get('/admin/topics/{topic}/subtopics', [AdminController::class, 'subtopic'])->name('admin.subtopics.index');
    Route::get('/topics/{topic}/sub-topics/create', [AdminController::class, 'createsubtopic'])->name('admin.subtopics.create');
    Route::post('/topics/{topic}/sub-topics', [AdminController::class, 'storesubtopic'])->name('admin.sub-topics.store');
    Route::get('/sub-topics/{subTopic}/edit', [AdminController::class, 'editsubtopic'])->name('admin.sub-topics.edit');
    Route::put('/sub-topics/{subTopic}', [AdminController::class, 'updatesubtopic'])->name('admin.sub-topics.update');



    Route::get('/admin/testcategory', [AdminController::class, 'testcategory'])->name('admin.testcategory');
    Route::get('/admin/testcategory/create', [AdminController::class, 'showCreateTestcategory'])->name('admin.testcategory.create');
    Route::post('/admin/testcategory/create', [AdminController::class, 'CreateTestcategory']);
    Route::get('/admin/testcategory/{id}/edit', [AdminController::class, 'showEditTestcategory'])->name('admin.testcategory.edit');
    Route::post('/admin/testcategory/{id}/update', [AdminController::class, 'updateTestcategory'])->name('admin.testcategory.update');


});

Route::middleware(['auth', 'role:student'])->group(function () {
    Route::get('/student/dashboard', [StudentController::class, 'dashboard'])->name('student.dashboard');
    Route::get('/student/exams', [StudentController::class, 'exams'])->name('student.exams');
    Route::get('/student/exam/{id}/attempt', [StudentController::class, 'attemptExam'])->name('student.exam.attempt');
    Route::post('/student/exam/{id}/submit', [StudentController::class, 'submitExam'])->name('student.exam.submit');
    Route::get('/student/payments', [StudentController::class, 'payments'])->name('student.payments');
    Route::get('/student/settings', [StudentController::class, 'settings'])->name('student.settings');
    Route::post('/student/settings', [StudentController::class, 'updateSettings']);
// GET route for showing the form
Route::get('/exam/{id}/purchase', [ExamController::class, 'showPurchase'])->name('exam.purchase');
Route::get('/student/exam/{id}/result', [StudentController::class, 'viewResult'])->name('student.exam.result');


// POST route for processing the payment
Route::post('/exam/{id}/purchase/process', [ExamController::class, 'purchase'])->name('exam.purchase.process');
Route::post('/exam/{id}/checkout', [ExamController::class, 'checkout'])->name('exam.checkout');
Route::get('/exam/{id}/success', [ExamController::class, 'success'])->name('exam.success');


});
