@extends('layouts.app')

@section('title', 'topics')

@section('content')
<h1>Available Topics</h1>
<div class="row">
    @foreach ($topics as $topic)
    <div class="col-md-4 mb-4">
        <div class="card">
            <img src="{{ $topic->topic_image ? asset('storage/' . $topic->topic_image) : 'https://via.placeholder.com/150' }}" class="card-img-top" height="200" width="150" alt="{{ $topic->topic_name }}">
            <div class="card-body">
                <h5 class="card-title">{{ $topic->topic_name }}</h5>
                <p class="card-text">Percentage: {{ $topic->topic_Percentage }} %</p>
                <a href="{{ route('topic.test', $topic->id) }}" class="btn btn-primary">View Test</a>
            </div>
        </div>
    </div>
    @endforeach
</div>
@endsection
