@extends('layouts.app')

@section('title', 'Exam Result')

@section('content')
<div class="container">
    <h1>Exam Result - {{ $studentExam->exam->name }}</h1>

    <div class="card mt-4">
        <div class="card-body">
            <p><strong>Score:</strong> {{ $latestResult->score }}</p>
            <p><strong>Status:</strong>
                @if ($latestResult->passed)
                    <span class="text-success">Passed</span>
                @else
                    <span class="text-danger">Not Passed</span>
                @endif
            </p>

            <h4 class="mt-4">Your Answers:</h4>
            <ul>
{{-- {{dd($latestResult)}} --}}

@foreach ($latestResult->answers as $questionId => $answer)
@php
    $question = \App\Models\Question::find($questionId);
@endphp
@if ($question)
    <li>
        <strong>Q:</strong> {{ $question->question }}<br>

        @php
            $options = $question->options;
        @endphp

        <strong>Your Answer:</strong>
        {{ isset($options[$answer]) ? $options[$answer] : 'Not Answered' }}
        <br>

        <strong>Correct Answer:</strong>
        {{ isset($options[$question->correct_option]) ? $options[$question->correct_option] : 'Not Available' }}
    </li>
@endif
@endforeach

            </ul>
        </div>
    </div>
</div>
@endsection
