@extends('layouts.app')

@section('title', 'My Exams')

@section('content')
<h1>My Exams</h1>
<table class="table">
    <thead>
        <tr>
            <th>Exam</th>
            <th>Attempts</th>
            <th>Max Attempts</th>
            <th>Status</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($studentExams as $studentExam)
        <tr>
            <td>{{ $studentExam->exam->name }}</td>
            <td>{{ $studentExam->attempts }}</td>
            <td>{{ $studentExam->exam->max_attempts }}</td>
            <td>
                @if ($studentExam->results()->where('passed', true)->exists())
                    Passed
                @elseif ($studentExam->attempts >= $studentExam->exam->max_attempts)
                    Max Attempts Reached
                @else
                    Not Passed
                @endif
            </td>
            <td>
                @if ($studentExam->results()->where('passed', true)->exists())
                    <a href="{{ route('student.exam.result', $studentExam->exam->id) }}" class="btn btn-sm btn-info">View Result</a>
                @elseif ($studentExam->attempts >= $studentExam->exam->max_attempts)
                    <a href="{{ route('exam.purchase', $studentExam->exam->id) }}" class="btn btn-sm btn-primary">Repurchase</a>
                @else
                    <a href="{{ route('student.exam.attempt', $studentExam->exam->id) }}" class="btn btn-sm btn-primary">Attempt</a>
                @endif
            </td>
        </tr>
        @endforeach
    </tbody>
</table>
@endsection
