@extends('layouts.app')

@section('title', 'Attempt Exam')

@section('content')
<style>
    #timer {
        position: fixed;
        top: 20px;
        right: 20px;
        background-color: #ff4d4f;
        color: white;
        font-size: 1.5rem;
        font-weight: bold;
        padding: 10px 20px;
        border-radius: 10px;
        z-index: 9999;
        box-shadow: 0 0 10px rgba(0,0,0,0.2);
        font-family: 'Courier New', Courier, monospace;
    }
</style>

<div id="timer"></div>

<h1>{{ $exam->name }}</h1>
<form id="exam-form" method="POST" action="{{ route('student.exam.submit', $exam->id) }}">
    @csrf
    @foreach ($questions as $index => $question)
    <div class="mb-4">
        <p><strong>Question {{ $index + 1 }}:</strong> {{ $question->question }}</p>
        @foreach ($question->options as $optionIndex => $option)
        <div class="form-check">
            <input class="form-check-input" type="radio" name="answers[{{ $question->id }}]" value="{{ $optionIndex }}" required>
            <label class="form-check-label">{{ $option }}</label>
        </div>
        @endforeach
    </div>
    @endforeach
    <button type="submit" class="btn btn-primary">Submit Exam</button>
</form>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const durationInMinutes = @json($exam->duration_minutes);
        let timeLeft = durationInMinutes * 60;

        const timerDisplay = document.getElementById('timer');
        const examForm = document.getElementById('exam-form');

        function updateTimer() {
            const minutes = Math.floor(timeLeft / 60);
            const seconds = timeLeft % 60;
            timerDisplay.textContent = `${String(minutes).padStart(2, '0')}:${String(seconds).padStart(2, '0')}`;
            timeLeft--;

            if (timeLeft < 0) {
                clearInterval(timerInterval);
                alert("Time is up! Submitting your exam...");
                examForm.submit();
            }
        }

        updateTimer();
        const timerInterval = setInterval(updateTimer, 1000);
    });
</script>
@endsection
