<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'Online Exam Portal')</title>
    <link href="{{ asset('css/app.css') }}" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-light bg-light">
        <div class="container">
            <a class="navbar-brand" href="{{ route('home') }}">Exam Portal</a>
            <div class="collapse navbar-collapse">
                <ul class="navbar-nav ms-auto">
                    @if (Auth::check() && Auth::user()->role === 'admin')
                        <li class="nav-item"><a class="nav-link" href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                        <li class="nav-item"><a class="nav-link" href="{{ route('admin.topic') }}">Topic</a></li>
                        <li class="nav-item"><a class="nav-link" href="{{ route('admin.testcategory') }}">Test Category</a></li>
                        <li class="nav-item"><a class="nav-link" href="{{ route('admin.exams') }}">Test</a></li>
                        <li class="nav-item"><a class="nav-link" href="{{ route('admin.students') }}">Students</a></li>
                        <li class="nav-item"><a class="nav-link" href="{{ route('admin.payments') }}">Payments</a></li>
                        <li class="nav-item"><a class="nav-link" href="{{ route('admin.settings') }}">Settings</a></li>
                        <li class="nav-item"><a class="nav-link" href="{{ route('admin.coupons.index') }}">Coupons</a></li>
                        <li class="nav-item"><a class="nav-link" href="{{ route('logout') }}">Logout</a></li>
                    @elseif (Auth::check() && Auth::user()->role === 'student')
                        <li class="nav-item"><a class="nav-link" href="{{ route('student.dashboard') }}">Dashboard</a></li>
                        <li class="nav-item"><a class="nav-link" href="{{ route('student.exams') }}">Exams</a></li>
                        <li class="nav-item"><a class="nav-link" href="{{ route('student.payments') }}">Payments</a></li>
                        <li class="nav-item"><a class="nav-link" href="{{ route('student.settings') }}">Settings</a></li>
                        <li class="nav-item"><a class="nav-link" href="{{ route('logout') }}">Logout</a></li>
                    @else
                        <li class="nav-item"><a class="nav-link" href="{{ route('home') }}">Home</a></li>
                        <li class="nav-item"><a class="nav-link" href="{{ route('topic') }}">Topics</a></li>
                        <li class="nav-item"><a class="nav-link" href="#code-of-conduct">Code of Conduct</a></li>
                        <li class="nav-item"><a class="nav-link" href="#about">About</a></li>
                        <li class="nav-item"><a class="nav-link" href="#contact">Contact</a></li>
                        <li class="nav-item"><a class="nav-link" href="{{ route('login') }}">Login</a></li>
                        <li class="nav-item"><a class="nav-link" href="{{ route('register') }}">Register</a></li>
                    @endif
                </ul>
            </div>
        </div>
    </nav>

    <div class="container my-5">
        @yield('content')
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    @yield('scripts')
</body>
</html>
