@extends('layouts.app')

@section('title', 'Exams')

@section('content')
<h1>Available Test</h1>
<div class="row">
    @foreach ($exams as $exam)
    <div class="col-md-4 mb-4">
        <div class="card">
            <img src="{{ $exam->image ? asset('storage/' . $exam->image) : 'https://via.placeholder.com/150' }}" class="card-img-top" alt="{{ $exam->name }}">
            <div class="card-body">
                <h5 class="card-title">{{ $exam->name }}</h5>
                <h5 class="card-title">{{ $topics->firstWhere('id', $exam->topic_id)?->topic_name ?? 'N/A' }}</h5>
                <h5 class="card-title">{{ $testCategories->firstWhere('id', $exam->test_category_id)?->testcategory_name ?? 'N/A' }}</h5>
                {{-- <p class="card-text">Price: ${{ $exam->amount }}</p> --}}

                <a href="{{ route('exam.purchase', $exam->id) }}" class="btn btn-primary">Buy Now</a>

                <p class="card-text"> price details:</p>



                @php
    $currency = session('currency', 'USD');
    $testCat = $exam->testCategory;

    $price = match ($currency) {
        'AED' => $testCat->gcc_std ?? 0,
        'INR' => $testCat->ind_std ?? 0,
        default => $testCat->us_std ?? 0,
    };
@endphp

<p class="card-text">Price: {{ number_format($price, 2) }} {{ $currency }}</p>



            </div>
        </div>
    </div>
    @endforeach
</div>
@endsection
