@extends('layouts.app')

@section('title', 'Purchase Exam')

@section('content')
<div class="container mt-4">
    <h1>Purchase Exam: {{ $exam->name }}</h1>
    <p>Amount: ${{ number_format($exam->amount, 2) }}</p>

    {{-- Show validation errors --}}
    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('exam.checkout', $exam->id) }}" method="POST">
        @csrf

        {{-- Coupon Code --}}
        <div class="mb-3">
            <label for="coupon_code" class="form-label">Coupon Code (optional)</label>
            <input type="text" name="coupon_code" id="coupon_code"
                   class="form-control" value="{{ old('coupon_code') }}"
                   placeholder="Enter your coupon code">
        </div>

        <button type="submit" class="btn btn-primary">
            Pay ${{ number_format($exam->amount, 2) }} via Stripe
        </button>
    </form>
</div>
@endsection
