@extends('layouts.app')

@section('title', 'topics')

@section('content')
<h1>topics</h1>
<a href="{{ route('admin.topics.create') }}" class="btn btn-primary mb-3">Create Topic</a>
<table class="table">
    <thead>
        <tr>
            <th>Si.no</th>
            <th>Name</th>
            <th>Image</th>
            <th>Percentage</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($topics as $topic)

        {{-- {{dd($topics)}} --}}
        <tr>
            <td>{{$loop->iteration}}</td>
            <td>{{ $topic->topic_name }}</td>
            <td>
                @if($topic->topic_image)
                    <img src="{{ asset('storage/' . $topic->topic_image) }}" alt="Topic Image" height="75px" width="100px">
                @else
                    No Image
                @endif
            </td>

            <td>{{ $topic->topic_Percentage }}</td>
            <td>
                <a href="{{ route('admin.topics.edit', $topic->id) }}" class="btn btn-sm btn-warning">Edit</a>
                <a href="{{ route('admin.subtopics.index', $topic->id) }}" class="btn btn-sm btn-info">Sub-topics</a>
            </td>
        </tr>
        @endforeach
    </tbody>
</table>
@endsection
