@extends('layouts.app')

@section('title', 'Edit topic')

@section('content')
<div class="container py-4">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0">Edit topic</h4>
        </div>
        {{-- {{dd($topic)}} --}}
        <div class="card-body">
            <form method="POST" action="{{ route('admin.topics.update', $topic->id) }}" enctype="multipart/form-data">
                @csrf

                <div class="row">
                    <div class="mb-3 col-md-6">
                        <label for="topic_name" class="form-label">Topic Name</label>
                        <input type="text" class="form-control" id="topic_name" name="topic_name" value="{{ $topic->topic_name  }}" required>
                    </div>

                    <div class="mb-3 col-md-6">
                        <label for="topic_Percentage" class="form-label">Percentage</label>
                        <input type="number" class="form-control" id="topic_Percentage" name="topic_Percentage" value="{{ $topic->topic_Percentage }}" required>
                    </div>

                    <div class="mb-3 col-md-6">
                        <label for="topic_image" class="form-label">topic Image</label>
                        <input type="file" class="form-control" id="topic_image" name="topic_image">
                        @if ($topic->topic_image)
                            <div class="mt-2">
                                <img src="{{ asset('storage/' . $topic->topic_image) }}" alt="{{ $topic->name }}" width="120" class="img-thumbnail">
                            </div>
                        @endif
                    </div>
                </div>

                <div class="d-grid mt-3">
                    <button type="submit" class="btn btn-success">Update topic</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
