@extends('layouts.app')

@section('title', 'Test Category')

@section('content')
<h1>Test Category</h1>
<a href="{{ route('admin.testcategory.create') }}" class="btn btn-primary mb-3">Create Test Category</a>
<table class="table">
    <thead>
        <tr>
            <th>Si.no</th>
            <th>Category Name</th>
            <th>GCC Students</th>
            <th>GCC Candidates</th>
            <th>US Students</th>
            <th>US Candidates</th>
            <th>Indian Students</th>
            <th>Indian Candidates</th>
            <th>Action</th>

        </tr>
    </thead>
    <tbody>
        @foreach ($testcategories as $testcategory)

        {{-- {{dd($topics)}} --}}
        <tr>
            <td>{{$loop->iteration}}</td>
            <td>{{ $testcategory->testcategory_name }}</td>
            <td>{{ $testcategory->gcc_std }} AED</td>
            <td>{{ $testcategory->gcc_can }} AED</td>
            <td>{{ $testcategory->us_std }} USD</td>
            <td>{{ $testcategory->us_can }} USD</td>
            <td>{{ $testcategory->ind_std }} INR</td>
            <td>{{ $testcategory->ind_can }} INR</td>
            <td>
                <a href="{{ route('admin.testcategory.edit', $testcategory->id) }}" class="btn btn-sm btn-warning">Edit</a>
            </td>
        </tr>
        @endforeach
    </tbody>
</table>
@endsection
