@extends('layouts.app')

@section('title', 'Edit Test Category')

@section('content')
<div class="container py-4">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0">Edit Test Category</h4>
        </div>
        {{-- {{dd($topic)}} --}}
        <div class="card-body">
            <form method="POST" action="{{ route('admin.testcategory.update', $testcategory->id) }}" enctype="multipart/form-data">
                @csrf

                <div class="row">
                    <div class="mb-3 col-md-12">
                        <label for="testcategory_name" class="form-label">Test Category Name</label>
                        <input type="text" class="form-control" id="testcategory_name" name="testcategory_name" value="{{ $testcategory->testcategory_name  }}" required>
                    </div>

                    <div class="mb-3 col-md-6">
                        <label for="gcc_std" class="form-label">GCC Students</label>
                        <input type="number" class="form-control" id="gcc_std" name="gcc_std" value="{{ $testcategory->gcc_std }}" required>
                    </div>

                    <div class="mb-3 col-md-6">
                        <label for="gcc_can" class="form-label">GCC Candidates</label>
                        <input type="number" class="form-control" id="gcc_can" name="gcc_can" value="{{ $testcategory->gcc_can }}" required>
                    </div>

                    <div class="mb-3 col-md-6">
                        <label for="us_std" class="form-label">US Students</label>
                        <input type="number" class="form-control" id="us_std" name="us_std" value="{{ $testcategory->us_std }}" required>
                    </div>

                    <div class="mb-3 col-md-6">
                        <label for="us_can" class="form-label">US Candidates</label>
                        <input type="number" class="form-control" id="us_can" name="us_can" value="{{ $testcategory->us_can }}" required>
                    </div>

                    <div class="mb-3 col-md-6">
                        <label for="ind_std" class="form-label">IND Students</label>
                        <input type="number" class="form-control" id="ind_std" name="ind_std" value="{{ $testcategory->ind_std }}" required>
                    </div>

                    <div class="mb-3 col-md-6">
                        <label for="ind_can" class="form-label">IND Candidates</label>
                        <input type="number" class="form-control" id="ind_can" name="ind_can" value="{{ $testcategory->ind_can }}" required>
                    </div>
                </div>

                <div class="d-grid mt-3">
                    <button type="submit" class="btn btn-success">Update Test Category</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
