@extends('layouts.app')

@section('title', 'Sub Topics')

@section('content')
    <div class="container">
        <h2>Sub Topics of: {{ $topic->topic_name }}</h2>

        <a href="{{ route('admin.subtopics.create', $topic->id) }}" class="btn btn-success mb-3">
            Add Sub Topic
        </a>

        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>SI.No</th>
                    <th>Name</th>
                    <th>Description</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse ($subtopics as $index => $subTopic)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>{{ $subTopic->name }}</td>
                        <td>{{ $subTopic->description }}</td>
                        <td>
                            <a href="{{ route('admin.sub-topics.edit', $subTopic->id) }}" class="btn btn-sm btn-warning">
                                Edit
                            </a>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="4">No sub-topics found for this topic.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
@endsection
