@extends('layouts.app')

@section('title', 'Questions')

@section('content')
<div class="container mt-5">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Questions for <strong>{{ $exam->name }}</strong></h2>
        <a href="{{ route('admin.questions.create', $exam->id) }}" class="btn btn-success">➕ Add Question</a>
    </div>

    @if ($questions->isEmpty())
        <div class="alert alert-info">No questions have been added yet.</div>
    @else
        <table class="table table-bordered table-striped">
            <thead class="table-dark">
                <tr>
                    <th style="width: 2%;">Si.no</th>
                    <th style="width: 30%;">Question</th>
                    <th style="width: 30%;">Options</th>
                    <th style="width: 15%;">Correct Answer</th>
                    <th style="width: 15%;">is_hard</th>
                    <th style="width: 10%;">Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($questions as $question)
                <tr>
                    <td>{{$loop->iteration}}</td>
                    <td>{{ $question->question }}</td>
                    <td>
                        <ol type="A" class="mb-0">
                            @foreach ($question->options as $index => $option)
                                <li @if($index == $question->correct_option) class="fw-bold text-success" @endif>
                                    {{ $option }}
                                </li>
                            @endforeach
                        </ol>
                    </td>
                    <td class="text-success fw-bold">
                        {{ $question->options[$question->correct_option] ?? 'N/A' }}
                    </td>
                    <td>{{ $question->is_hard ? 'Yes' : 'No' }}</td>


                    <td>
                        <a href="{{ route('admin.questions.edit', $question->id) }}" class="btn btn-sm btn-primary">Edit</a>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    @endif
</div>
@endsection
