@extends('layouts.app')

@section('title', 'Edit Question')

@section('content')
<div class="container mt-5">
    <h2 class="mb-4">Edit Question for <strong>{{ $exam->name }}</strong></h2>

    <form method="POST" action="{{ route('admin.questions.update', $question->id) }}">
        @csrf

        <div class="mb-4">
            <label for="question" class="form-label">Question <span class="text-danger">*</span></label>
            <textarea class="form-control" id="question" name="question" rows="3" required>{{ old('question', $question->question) }}</textarea>
        </div>

        <h5 class="mb-3">Options</h5>
        <div class="row">
            @foreach($question->options as $index => $option)
            <div class="col-md-6 mb-3">
                <label for="option_{{ $index }}" class="form-label">Option {{ $index + 1 }}</label>
                <input type="text" class="form-control" id="option_{{ $index }}" name="options[]" value="{{ old('options.' . $index, $option) }}" required>
            </div>
            @endforeach
        </div>

        <div class="mb-4">
            <label for="correct_option" class="form-label">Correct Option <span class="text-danger">*</span></label>
            <select class="form-select w-50" id="correct_option" name="correct_option" required>
                <option value="">-- Select the correct option --</option>
                @for ($i = 0; $i < 4; $i++)
                    <option value="{{ $i }}" {{ old('correct_option', $question->correct_option) == $i ? 'selected' : '' }}>
                        Option {{ $i + 1 }}
                    </option>
                @endfor
            </select>
        </div>

        <button type="submit" class="btn btn-primary">💾 Update Question</button>
        <a href="{{ route('admin.questions', $exam->id) }}" class="btn btn-secondary ms-2">Cancel</a>
    </form>
</div>
@endsection
