@extends('layouts.app')

@section('title', 'Add Question')

@section('content')
<div class="container mt-5">
    <h2 class="mb-4">Add Question for <strong>{{ $exam->name }}</strong></h2>

    <form method="POST" action="{{ route('admin.questions.create', $exam->id) }}">
        @csrf

        <div class="mb-4">
            <label for="question" class="form-label">Question <span class="text-danger">*</span></label>
            <textarea class="form-control" id="question" name="question" rows="3" placeholder="Enter your question here..." required></textarea>
        </div>

        <h5 class="mb-3">Options</h5>
        <div class="row">
            @for ($i = 0; $i < 4; $i++)
            <div class="col-md-6 mb-3">
                <label for="option_{{ $i }}" class="form-label">Option {{ $i + 1 }}</label>
                <input type="text" class="form-control" id="option_{{ $i }}" name="options[]" placeholder="Enter option {{ $i + 1 }}" required>
            </div>
            @endfor
        </div>

        <div class="mb-4">
            <label for="correct_option" class="form-label">Correct Option <span class="text-danger">*</span></label>
            <select class="form-select w-50" id="correct_option" name="correct_option" required>
                <option value="">-- Select the correct option --</option>
                <option value="0">Option 1</option>
                <option value="1">Option 2</option>
                <option value="2">Option 3</option>
                <option value="3">Option 4</option>
            </select>
        </div>

        <div class="mb-4">
        <div class="form-check form-switch mt-4">
            <input type="checkbox" class="form-check-input" id="is_hard" name="is_hard">
            <label class="form-check-label" for="is_hard">Hard</label>
        </div>
        </div>

        <button type="submit" class="btn btn-success">➕ Add Question</button>
    </form>
</div>
@endsection
