@extends('layouts.app')

@section('title', 'Payments')

@section('content')
<h1>Payment History</h1>
<table class="table">
    <thead>
        <tr>
            <th>Student</th>
            <th>Exam</th>
            <th>Amount</th>
            <th>Status</th>
            <th>Date</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($payments as $payment)
        <tr>
            <td>{{ $payment->user->name }}</td>
            <td>{{ $payment->exam->name }}</td>
            <td>${{ $payment->amount }}</td>
            <td>{{ $payment->status }}</td>
            <td>{{ $payment->created_at->format('Y-m-d') }}</td>
        </tr>
        @endforeach
    </tbody>
</table>
@endsection
