@extends('layouts.app')

@section('title', 'Exams')

@section('content')
<h1>Exams</h1>
<a href="{{ route('admin.exams.create') }}" class="btn btn-primary mb-3">Create Exam</a>
<table class="table">
    <thead>
        <tr>
            <th>Name</th>
            <th>Amount</th>
            <th>Topic</th>
            <th>category</th>
            <th>Max Attempts</th>
            <th>Total Mark</th>
            <th>Pass Mark</th>
            <th>Status</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($exams as $exam)
        <tr>
            <td>{{ $exam->name }}</td>
            <td>${{ $exam->amount }}</td>
            <td>
                {{ $topics->firstWhere('id', $exam->topic_id)?->topic_name ?? 'N/A' }}
            </td>
            <td>
                {{ $testCategories->firstWhere('id', $exam->test_category_id)?->testcategory_name ?? 'N/A' }}
            </td>

            <td>{{ $exam->max_attempts }}</td>
            <td>{{ $exam->total_mark }}</td>
            <td>{{ $exam->pass_mark }}</td>
            <td>{{ $exam->is_active ? 'Active' : 'Inactive' }}</td>
            <td>
                <a href="{{ route('admin.exams.edit', $exam->id) }}" class="btn btn-sm btn-warning">Edit</a>
                <a href="{{ route('admin.questions', $exam->id) }}" class="btn btn-sm btn-info">Questions</a>
            </td>
        </tr>
        @endforeach
    </tbody>
</table>
@endsection
