@extends('layouts.app')

@section('title', 'Edit Exam')

@section('content')
<div class="container py-4">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0">Edit Exam</h4>
        </div>
        {{-- {{dd($exam)}} --}}

        @if(session('error'))
    <div class="alert alert-danger">
        {{ session('error') }}
    </div>
@endif

        <div class="card-body">
            <form method="POST" action="{{ route('admin.exams.update', $exam->id) }}" enctype="multipart/form-data">
                @csrf

                <div class="row">
                    <div class="mb-3 col-md-6">
                        <label for="name" class="form-label">Exam Name</label>
                        <input type="text" class="form-control" id="name" name="name" value="{{ $exam->name }}" required>
                    </div>

                    <div class="mb-3 col-md-6">
                        <label for="amount" class="form-label">Amount ($)</label>
                        <input type="number" class="form-control" id="amount" name="amount" step="0.01" value="{{ $exam->amount }}" required>
                    </div>


                    <div class="mb-3 col-md-6">
                        <label for="topic_id" class="form-label">Select Topic</label>
                        <select class="form-select" id="topic_id" name="topic_id" required>
                            <option value="">-- Select Topic --</option>
                            @foreach($topics as $topic)
                                <option value="{{ $topic->id }}" {{ $exam->topic_id == $topic->id ? 'selected' : '' }}>
                                    {{ $topic->topic_name }}
                                </option>
                            @endforeach
                        </select>
                    </div>


                        <div class="mb-3 col-md-6">
                            <label for="test_category_id" class="form-label">Select Test Category</label>
                            <select class="form-select" id="test_category_id" name="test_category_id" required>
                                <option value="">-- Select Test Category --</option>
                                @foreach($testCategories as $category)
                                    <option value="{{ $category->id }}" {{ $exam->test_category_id == $category->id ? 'selected' : '' }}>
                                        {{ $category->testcategory_name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>



                    <div class="mb-3 col-md-6">
                        <label for="max_attempts" class="form-label">Max Attempts</label>
                        <input type="number" class="form-control" id="max_attempts" name="max_attempts" value="{{ $exam->max_attempts }}" required>
                    </div>

                    <div class="mb-3 col-md-6">
                        <label for="total_mark" class="form-label">Total Mark</label>
                        <input type="number" class="form-control" id="total_mark" name="total_mark" value="{{ $exam->total_mark }}" required>
                    </div>

                    <div class="mb-3 col-md-6">
                        <label for="mark_per_question" class="form-label">Mark per Question</label>
                        <input type="number" class="form-control" id="mark_per_question" name="mark_per_question" value="{{ $exam->mark_per_question }}" required>
                    </div>

                    <div class="mb-3 col-md-6">
                        <label for="pass_mark" class="form-label">Pass Mark</label>
                        <input type="number" class="form-control" id="pass_mark" name="pass_mark" value="{{ $exam->pass_mark }}" required>
                    </div>

                    <div class="mb-3 col-md-6">
                        <label for="duration_minutes" class="form-label">Duration (Minutes)</label>
                        <input type="number" class="form-control" id="duration_minutes" name="duration_minutes" value="{{ $exam->duration_minutes }}" required>
                    </div>

                    <div class="mb-3 col-md-6">
                        <label for="image" class="form-label">Exam Image</label>
                        <input type="file" class="form-control" id="image" name="image">
                        @if ($exam->image)
                            <div class="mt-2">
                                <img src="{{ asset('storage/' . $exam->image) }}" alt="{{ $exam->name }}" width="120" class="img-thumbnail">
                            </div>
                        @endif
                    </div>

                    <div class="col-md-6">
                        <label for="hard_ques" class="form-label">No Of Hard Questions</label>
                        <input type="number" class="form-control" id="hard_ques" name="hard_ques" min="0" value="{{ $exam->hard_ques }}" required>
                    </div>

                    <div class="mb-3 col-md-6 d-flex align-items-center">
                        <div class="form-check form-switch mt-4">
                            <input type="checkbox" class="form-check-input" id="is_active" name="is_active" {{ $exam->is_active ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_active">Active</label>
                        </div>
                    </div>
                </div>

                <div class="d-grid mt-3">
                    <button type="submit" class="btn btn-success">Update Exam</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
