@extends('layouts.app')

@section('content')
<div class="container">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2>All Coupons</h2>
        <a href="{{ route('admin.coupons.create') }}" class="btn btn-success">Create New Coupon</a>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    @if($coupons->count())
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Code</th>
                    <th>Type</th>
                    <th>Value</th>
                    <th>Usage Limit</th>
                    <th>Used</th>
                    <th>Remarks</th>
                    <th>Created At</th>
                </tr>
            </thead>
            <tbody>
                @foreach($coupons as $coupon)
                    <tr>
                        <td><strong>{{ $coupon->code }}</strong></td>
                        <td>{{ ucfirst($coupon->type) }}</td>
                        <td>
                            {{ $coupon->type === 'percent' ? $coupon->value . '%' : '₹' . $coupon->value }}
                        </td>
                        <td>{{ $coupon->usage_limit }}</td>
                        <td>{{ $coupon->used_count }}</td>
                        <td>{{ $coupon->remarks ?? '-' }}</td>
                        <td>{{ $coupon->created_at->format('d M Y') }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @else
        <p>No coupons found.</p>
    @endif
</div>
@endsection
