@extends('layouts.app')

@section('content')
<div class="container">
    <h2>Create Coupon Code</h2>

    {{-- Success Message --}}
    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    {{-- Form --}}
    <form action="{{ route('admin.coupons.store') }}" method="POST">
        @csrf

        {{-- Coupon Code --}}
        <div class="mb-3">
            <label for="code" class="form-label">Coupon Code</label>
            <input type="text" name="code" id="code"
                   class="form-control @error('code') is-invalid @enderror"
                   value="{{ old('code') }}" required>
            @error('code')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        {{-- Discount Type --}}
        <div class="mb-3">
            <label for="type" class="form-label">Discount Type</label>
            <select name="type" id="type"
                    class="form-select @error('type') is-invalid @enderror" required>
                <option value="">-- Select Type --</option>
                <option value="percent" {{ old('type') == 'percent' ? 'selected' : '' }}>Percent (%)</option>
                <option value="amount" {{ old('type') == 'amount' ? 'selected' : '' }}>Fixed Amount (e.g., ₹)</option>
            </select>
            @error('type')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        {{-- Value --}}
        <div class="mb-3">
            <label for="value" class="form-label">Value</label>
            <input type="number" name="value" id="value"
                   class="form-control @error('value') is-invalid @enderror"
                   step="0.01" min="0" value="{{ old('value') }}" required>
            @error('value')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        {{-- Usage Limit --}}
        <div class="mb-3">
            <label for="usage_limit" class="form-label">Usage Limit</label>
            <input type="number" name="usage_limit" id="usage_limit"
                   class="form-control @error('usage_limit') is-invalid @enderror"
                   min="1" value="{{ old('usage_limit') }}" required>
            @error('usage_limit')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        {{-- Remarks --}}
        <div class="mb-3">
            <label for="remarks" class="form-label">Remarks</label>
            <textarea name="remarks" id="remarks"
                      class="form-control @error('remarks') is-invalid @enderror"
                      rows="3">{{ old('remarks') }}</textarea>
            @error('remarks')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        {{-- Submit --}}
        <button type="submit" class="btn btn-primary">Create Coupon</button>
    </form>
</div>
@endsection
