@extends('layouts.app')

@section('title', 'Create topic')

@section('content')
<div class="container mt-4">
    <div class="card shadow rounded">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0">Create New topic</h4>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.topics.create') }}" enctype="multipart/form-data">
                @csrf
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="topic_name" class="form-label">Topic Name</label>
                        <input type="text" class="form-control" id="topic_name" name="topic_name" placeholder="Enter topic title" required>
                    </div>

                    <div class="col-md-6">
                        <label for="topic_image" class="form-label">Upload Image</label>
                        <input type="file" class="form-control" id="topic_image" name="topic_image">
                    </div>
                    {{-- <div class="col-md-6">
                        <label for="amount" class="form-label">Amount ($)</label>
                        <input type="number" class="form-control" id="amount" name="amount" step="0.01" placeholder="0.00" required>
                    </div> --}}
                </div>

                <div class="row mb-3">

                    <div class="col-md-6">
                        <label for="topic_Percentage" class="form-label">Percentage</label>
                        <input type="number" class="form-control" id="topic_Percentage" name="topic_Percentage" min="1" placeholder="e.g. 2" required>
                    </div>
                </div>

                {{-- <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="duration_minutes" class="form-label">Duration (in minutes)</label>
                        <input type="number" class="form-control" id="duration_minutes" name="duration_minutes" min="1" placeholder="e.g. 30" required>
                    </div>
                    <div class="col-md-6">
                        <label for="total_mark" class="form-label">Total Marks</label>
                        <input type="number" class="form-control" id="total_mark" name="total_mark" min="1" required>
                    </div>
                </div> --}}

                {{-- <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="mark_per_question" class="form-label">Mark per Question</label>
                        <input type="number" class="form-control" id="mark_per_question" name="mark_per_question" min="1" required>
                    </div>
                    <div class="col-md-6">
                        <label for="pass_mark" class="form-label">Pass Mark</label>
                        <input type="number" class="form-control" id="pass_mark" name="pass_mark" min="1" required>
                    </div>
                </div> --}}

                <div class="text-end">
                    <button type="submit" class="btn btn-success">Create topic</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
