document.addEventListener('DOMContentLoaded', function () {
    document.documentElement.requestFullscreen().catch(err => {
        console.error('Fullscreen request failed:', err);
    });

    let warningCount = 0;
    const maxWarnings = 3;

    document.addEventListener('visibilitychange', function () {
        if (document.hidden) {
            warningCount++;
            if (warningCount >= maxWarnings) {
                if (confirm('You have switched tabs multiple times. Submit exam now?')) {
                    document.getElementById('exam-form').submit();
                }
            } else {
                alert('Switching tabs is prohibited. Warning ' + warningCount + ' of ' + maxWarnings + '.');
            }
        }
    });

    window.addEventListener('blur', function () {
        warningCount++;
        if (warningCount >= maxWarnings) {
            if (confirm('You have left the exam window. Submit exam now?')) {
                document.getElementById('exam-form').submit();
            }
        } else {
            alert('Please stay on the exam page. Warning ' + warningCount + ' of ' + maxWarnings + '.');
        }
    });

    document.addEventListener('fullscreenchange', function () {
        if (!document.fullscreenElement) {
            warningCount++;
            if (warningCount >= maxWarnings) {
                if (confirm('You have exited fullscreen. Submit exam now?')) {
                    document.getElementById('exam-form').submit();
                }
            } else {
                alert('Please remain in fullscreen mode. Warning ' + warningCount + ' of ' + maxWarnings + '.');
                document.documentElement.requestFullscreen();
            }
        }
    });
});
