<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('testcategories', function (Blueprint $table) {
            $table->id();
            $table->string('testcategory_name');
            $table->decimal('gcc_std', 8, 2);
            $table->decimal('gcc_can', 8, 2);
            $table->decimal('us_std', 8, 2);
            $table->decimal('us_can', 8, 2);
            $table->decimal('ind_std', 8, 2);
            $table->decimal('ind_can', 8, 2);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('testcategories');
    }
};
