<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Result extends Model
{
    use HasFactory;

    protected $fillable = [
        'student_exam_id', 'score', 'passed', 'answers',
    ];

    protected $casts = [
        'answers' => 'array',
    ];

    public function studentExam()
    {
        return $this->belongsTo(StudentExam::class);
    }
}
