<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Exam extends Model
{
    use HasFactory;

    protected $fillable = [
        'name', 'amount','topic_id','test_category_id', 'image', 'max_attempts', 'total_mark', 'mark_per_question', 'duration_minutes', 'pass_mark', 'is_active','hard_ques',
    ];

    public function questions()
    {
        return $this->hasMany(Question::class);
    }

    public function studentExams()
    {
        return $this->hasMany(StudentExam::class);
    }

    public function testCategory()
{
    return $this->belongsTo(testcategory::class, 'test_category_id');
}
}
