<?php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class DetectCurrency
{
    public function handle(Request $request, Closure $next)
    {
        if (!session()->has('currency')) {
            $ip = $request->ip();

            $response = Http::get("https://ipapi.co/{$ip}/json");

            if ($response->ok()) {
                $countryCode = $response->json('country_code');

                $currency = match ($countryCode) {
                    'AE', 'SA', 'KW', 'QA', 'OM', 'BH' => 'AED', // GCC
                    'IN' => 'INR',
                    default => 'USD',
                };

                session(['currency' => $currency]);
            } else {
                session(['currency' => 'USD']);
            }
        }

        return $next($request);
    }
}
